"""
最大子序列交替和
"""
from typing import List


class Solution:
    def maxAlternatingSum(self, nums: List[int]) -> int:
        """
        动态规划  打家劫舍  背包问题
        even 偶数
        odd 奇数
        """
        even, odd = 0, nums[0]  # 偶数`长度`子序列的最大交替和，初始为0；奇数`长度`子序列的最大交替和，初始为首个元素
        res = odd  # 所有子序列的最大最大交替和，由于元素非负，因此初始为even和odd的最大值即为odd=nums[0]
        for i in range(1, len(nums)):
            # 从第二个元素开始进行动规
            # 动态规划更新even和odd
            even = max(even, odd - nums[i])
            odd = max(odd, even + nums[i])
            # 更新最大最大交替和
            res = max(res, even, odd)
        return res


if __name__ == '__main__':
    result = Solution().maxAlternatingSum([4, 6, 5, 3])
    print(result)
