"""
最接近的三数之和
"""
import heapq
from typing import List


class Solution:
    def threeSumClosest(self, nums: List[int], target: int) -> int:
        """
        思路:最关键的是找出最接近的数
        :param nums:
        :param target:
        :return:
        """
        nums.sort()
        ans = nums[0] + nums[1] + nums[2]
        for i in range(len(nums)):
            left = i + 1
            right = len(nums) - 1
            while left < right:
                total = nums[i] + nums[left] + nums[right]
                if abs(target - total) < abs(target - ans):
                    ans = total
                if total > target:
                    right -= 1
                elif total < target:
                    left += 1
                else:
                    return total
        return ans


if __name__ == '__main__':
    result = Solution().threeSumClosest([-1, 2, 1, -4], 1)
    print(result)
