package com.kwan.shuyu.lesson5;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.net.DatagramPacket;
import java.net.DatagramSocket;

/**
 * 接收端 udp
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/19 11:24
 */
@Slf4j
public class Chat_002_receive {
    public static void main(String[] args) throws Exception {
        //1.创建socket
        DatagramSocket socket = new DatagramSocket(6666);
        while (true) { //2.接收数据包
            final byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
            socket.receive(packet);
            //断开连接 bye
            final byte[] data = packet.getData();
            final String receive = new String(data, 0, packet.getLength());
            log.info(receive);
            if (StringUtils.equalsIgnoreCase(receive, "bye")) {
                break;
            }
        }
        //3.关闭资源
        socket.close();
    }
}