package com.kwan.shuyu.netty_02_future;

import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import lombok.extern.slf4j.Slf4j;

/**
 * netty promise 测试 成功
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/26 21:07
 */
@Slf4j
public class TestNettyPromiseSuccess {
    public static void main(String[] args) throws Exception {
        EventLoop eventLoop = new NioEventLoopGroup().next();
        final DefaultPromise promise = new DefaultPromise(eventLoop);
        new Thread(() -> {
            log.info("开始计算....");
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            promise.setSuccess(20);
        }).start();
        //3.主线程通过future 来获取结果
        log.info("等待处理结果");
        log.info("处理结果是={}", promise.get());
    }
}