package com.kwan.shuyu.netty_01_netty.c13_closefeature;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.extern.slf4j.Slf4j;

import java.net.InetSocketAddress;
import java.util.Scanner;

/**
 * 客户端优雅关闭shutdownGracefully
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/23 16:43
 */
@Slf4j
public class TestEventLoop_02_client {
    public static void main(String[] args) throws InterruptedException {
        //1.启动类
        final NioEventLoopGroup group = new NioEventLoopGroup();
        final ChannelFuture channelFuture = new Bootstrap()
                // 2.添加 EventLoop
                .group(group)
                //3.选择客户端channel实现
                .channel(NioSocketChannel.class)
                // 4.添加处理器4
                .handler(new ChannelInitializer<NioSocketChannel>() {
                    @Override //在连接建立后被调用
                    protected void initChannel(NioSocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new LoggingHandler(LogLevel.INFO));
                        ch.pipeline().addLast(new StringEncoder());
                    }
                })
                //连接到服务器
                .connect(new InetSocketAddress("localhost", 8080));
        Channel channel = channelFuture.sync().channel();
        new Thread(() -> {
            final Scanner scanner = new Scanner(System.in);
            while (true) {
                final String line = scanner.nextLine();
                if ("q".equals(line)) {
                    channel.close();//close是异步操作,需要处理之后的操作
                    break;
                }
                channel.writeAndFlush(line);
            }
        }, "input").start();
        //获取 ClosedFuture 对象，1.异步处理关闭  2.同步处理
        ChannelFuture closeFuture = channel.closeFuture();
        System.out.println("waiting close.….");
        //异步处理关闭之后的操作
        closeFuture.addListener(
                new ChannelFutureListener() {
                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        log.debug("处理关闭之后的操作");
                        group.shutdownGracefully();//优雅关闭
                    }
                }
        );
    }
}