package com.kwan.shuyu.netty_01_bytebuffer;

import lombok.extern.slf4j.Slf4j;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

import static com.kwan.shuyu.until.ByteBufferUtil.debugAll;

/**
 * 字符串放入到ByteBuffer中
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
@Slf4j
public class ByteBuffer_10_Test_String {
    public static void main(String[] args) {
        //方式一,不会自动切换到读模式
        ByteBuffer buffer1 = ByteBuffer.allocate(16);
        buffer1.put("hello".getBytes());
        debugAll(buffer1);
        //方式二,自动切换到读模式
        ByteBuffer buffer2 = StandardCharsets.UTF_8.encode("hello");
        debugAll(buffer2);
        //方式三,自动切换到读模式
        final ByteBuffer buffer3 = ByteBuffer.wrap("hello".getBytes());
        debugAll(buffer3);
        //转为字符串
        final String s2 = StandardCharsets.UTF_8.decode(buffer2).toString();
        System.out.println(s2);
        final String s1 = StandardCharsets.UTF_8.decode(buffer1).toString();
        System.out.println(s1);//解码失败
        final String s3 = StandardCharsets.UTF_8.decode(buffer3).toString();
        System.out.println(s3);
    }
}
