package com.kwan.shuyu.netty_04_bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import lombok.extern.slf4j.Slf4j;

import static io.netty.buffer.ByteBufUtil.appendPrettyHexDump;
import static io.netty.util.internal.StringUtil.NEWLINE;

/**
 * ByteBuf  读数据
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/27 09:34
 */
@Slf4j
public class ByteBuf_06 {

    public static void main(String[] args) {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(10);
        buffer.writeBytes(new byte[]{1, 2, 3, 4});
        log(buffer);
        //上面代码创建了一个默认的ByteBuf（池化基于直接内存的 ByteBuf)，初始容量是10
        /**
         * read index:0 write index:4 capacity:10
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 01 02 03 04                                     |....            |
         * +--------+-------------------------------------------------+----------------+
         */
        buffer.writeInt(5);//int占四个字节
        log(buffer);
        /**
         * read index:0 write index:8 capacity:10
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 01 02 03 04 00 00 00 05                         |........        |
         * +--------+-------------------------------------------------+----------------+
         */
        buffer.writeInt(7);//int占四个字节
        log(buffer);
        /**
         * read index:0 write index:12 capacity:16
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 01 02 03 04 00 00 00 05 00 00 00 07             |............    |
         * +--------+-------------------------------------------------+----------------+
         */
        System.out.println(buffer.readByte());
        System.out.println(buffer.readByte());
        System.out.println(buffer.readByte());
        System.out.println(buffer.readByte());
        log(buffer);
        /**
         * 1
         * 2
         * 3
         * 4
         * read index:4 write index:12 capacity:16
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 00 00 00 05 00 00 00 07                         |........        |
         * +--------+-------------------------------------------------+----------------+
         */
    }

    private static void log(ByteBuf buffer) {
        int length = buffer.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder buf = new StringBuilder(rows * 80 * 2)
                .append("read index:").append(buffer.readerIndex())
                .append(" write index:").append(buffer.writerIndex())
                .append(" capacity:").append(buffer.capacity())
                .append(NEWLINE);
        appendPrettyHexDump(buf, buffer);
        System.out.println(buf.toString());
    }
}
