package com.kwan.shuyu.netty_02_future;

import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.*;

/**
 * Jdk Future 测试
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/26 21:07
 */
@Slf4j
public class TestJdkFuture {
    public static void main(String[] args) throws Exception {
        //1.线程池
        ExecutorService service = Executors.newFixedThreadPool(2);
        //2.提交任务
        Future<Integer> future = service.submit(new Callable<Integer>() {
            @Override
            public Integer call() throws Exception {
                Thread.sleep(1000);
                return 50;
            }
        });
        //3.主线程通过future 来获取结果
        log.info("等待处理结果");
        log.info("处理结果是={}", future.get());
    }
}