package com.kwan.shuyu.netty_02_future;

import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import lombok.extern.slf4j.Slf4j;

/**
 * netty promise 测试  成功和失败处理
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/26 21:07
 */
@Slf4j
public class TestNettyPromiseFailure {
    public static void main(String[] args) throws Exception {
        EventLoop eventLoop = new NioEventLoopGroup().next();
        final DefaultPromise promise = new DefaultPromise(eventLoop);
        new Thread(() -> {
            log.info("开始计算....");
            try {
//                int num = 1 / 0;
                Thread.sleep(1000);
                promise.setSuccess(20);
            } catch (InterruptedException e) {
                e.printStackTrace();
                promise.setFailure(e);
            }
        }).start();
        final Throwable cause = promise.cause();
        if (cause != null) {
            //3.主线程通过future 来获取结果
            log.info("等待处理结果");
            log.info("处理结果是={}", cause.getMessage());
        } else {
            //3.主线程通过future 来获取结果
            log.info("等待处理结果");
            log.info("处理结果是={}", promise.getNow());
        }
    }
}