package com.kwan.shuyu.netty_01_netty.c6_codec;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import lombok.extern.slf4j.Slf4j;

/**
 * 解码StringDecoder
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/23 10:51
 */
@Slf4j
public class TestEventLoop_01_server {
    public static void main(String[] args) {
        //普通任务
        final EventLoopGroup group = new DefaultEventLoopGroup();
        new ServerBootstrap()
                //boss 只负责ServerSocketChannel 上 accept 事件  worker只负责socketChannel上的读写
                .group(new NioEventLoopGroup(), new NioEventLoopGroup(2))
                .channel(NioServerSocketChannel.class)
                .childHandler(new ChannelInitializer<NioSocketChannel>() {
                    @Override
                    protected void initChannel(NioSocketChannel ch) throws Exception {
                        //添加解码器
                        ch.pipeline().addLast("handler0", new StringDecoder());
                    }
                })
                .bind(8080);
    }
}