package com.kwan.shuyu.netty_05_io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class NIOServer {
    public static void start(int port) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);//nonblocking
        InetSocketAddress address = new InetSocketAddress(port);
        //bind & listen
        serverChannel.bind(address);
        Selector selector = Selector.open();
        serverChannel.register(selector, SelectionKey.OP_ACCEPT);
        while (true) {
            selector.select();//scan
            Set<SelectionKey> readyKeys = selector.selectedKeys();
            Iterator<SelectionKey> it = readyKeys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                //accept
                if (key.isAcceptable()) {
                    ServerSocketChannel server = (ServerSocketChannel) key.channel();
                    SocketChannel socket = server.accept();
                    System.out.println("Accept !");
                    socket.configureBlocking(false);//don't forget to set nonblocking
                    socket.register(selector, SelectionKey.OP_READ);//tricky
                }
                if (key.isReadable()) {
                    SocketChannel socket = (SocketChannel) key.channel();
                    final ByteBuffer buffer = ByteBuffer.allocate(64);
                    final int bytesRead = socket.read(buffer);//also nonblock, how to convert byte to frame
                    if (bytesRead > 0) {
                        buffer.flip();
                        int ret = socket.write(buffer);
                        if (ret <= 0) {
                            //register op_write
                            socket.register(selector, SelectionKey.OP_WRITE);
                        }
                        buffer.clear();
                    } else if (bytesRead < 0) {//means connection closed
                        key.cancel();
                        socket.close();
                        System.out.println("Client close");
                    }
                }
//                 if (key.isWritable()) {
//                	 SocketChannel socket = (SocketChannel) key.channel();
//                	 final ByteBuffer buffer = ByteBuffer.allocate(64);
//                	 socket.write(buffer);
//                	 //remove
//                 }
                it.remove();//don't forget, why need to manually move?
            }
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        start(8084);
    }
}