package com.kwan.shuyu.netty_05_io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * @author : kwan
 * @date : 2021/10/13
 * @desc : BIO     存在C10k挑战
 */
public class BIOServer {
    public static void start(int port) throws IOException {
        //ServerSocket
        ServerSocket serverSocket = new ServerSocket();
        //bind & listen
        serverSocket.bind(new InetSocketAddress(port), 2);//backlog, accept queue was created in listen()
        while (true) {
            //accept
            final Socket clientSocket = serverSocket.accept();//block
            System.out.println("accept!");
            new Thread(() -> {// or user thread pool
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    String line = in.readLine();//block
                    while (line != null) {
                        out.println(line);
                        out.flush();
                        line = in.readLine();//block
                    }
                    clientSocket.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    try {
                        clientSocket.close();
                    } catch (IOException ee) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        start(8084);
    }
}