package com.kwan.shuyu.netty_03_nio.c7_optimization;

import com.kwan.shuyu.until.ByteBufferUtil;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;


/**
 * 工作线程
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/21 15:01
 */
public class Worker implements Runnable {
    private Thread thread;
    private Selector selector;
    private String name;
    private volatile boolean start = false;//还未初始化
    private ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue<>();

    public Worker(String name) {
        this.name = name;
    }

    /**
     * 初始化线程，和selector
     *
     * @param sc
     * @throws IOException
     */
    public void register(SocketChannel sc) throws IOException {
        if (!start) {
            selector = Selector.open();
            thread = new Thread(this, name);
            thread.start();
            start = true;
        }
        queue.add(() -> {
            try {
                sc.register(selector, SelectionKey.OP_READ, null);
            } catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
        selector.wakeup();
    }

    @Override
    public void run() {
        while (true) {
            try {
                selector.select();
                final Runnable task = queue.poll();
                if (task != null) {
                    task.run();
                }
                final Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    final SelectionKey key = iterator.next();
                    iterator.remove();
                    if (key.isReadable()) {
                        final ByteBuffer buffer = ByteBuffer.allocate(16);
                        final SocketChannel channel = (SocketChannel) key.channel();
                        channel.read(buffer);
                        buffer.flip();
                        ByteBufferUtil.debugAll(buffer);
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

