package com.kwan.shuyu.netty_01_bytebuffer;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;

/**
 * ByteBuffer写入文件
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class ByteBuffer_12_Test_Write {
    public static void main(String[] args) {
        final ByteBuffer b1 = StandardCharsets.UTF_8.encode("hello");
        final ByteBuffer b2 = StandardCharsets.UTF_8.encode("world");
        final ByteBuffer b3 = StandardCharsets.UTF_8.encode("秦书予");
        //绝对目录
        //final String path = "/Users/qinyingjie/Documents/idea-workspace/netty-demo/src/main/resources/word2.txt";
        //相对目录
        final String path = "word2.txt";
        try (FileChannel channel = new RandomAccessFile(path, "rw").getChannel()) {
            channel.write(new ByteBuffer[]{b1, b2, b3});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
