package com.kwan.shuyu.netty_01_bytebuffer;

import lombok.extern.slf4j.Slf4j;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * ByteBuffer读取文件内容,多次读取
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
@Slf4j
public class ByteBuffer_02_Test_hasRemaining {
    public static void main(String[] args) {
        try (FileChannel channel = new FileInputStream("data.txt").getChannel()) {
            ByteBuffer buffer = ByteBuffer.allocate(10);
            while (true) {
                final int len = channel.read(buffer);
                log.info("read len {}", len);
                if (len == -1) {//表示未读到数据
                    break;
                }
                buffer.flip();//读模式
                while (buffer.hasRemaining()) {
                    final byte b = buffer.get();
                    log.info("实际字节 {}", (char) b);
                }
                buffer.clear();//写模式
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
