package com.kwan.shuyu.advance_01_sticky_bag.c6;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.Charset;

/**
 * 服务端 基于长度字段的 帧解码器
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/27 19:08
 * LengthFieldBasedFrameDecoder(
 * int maxFrameLength,     限制最大长度
 * int lengthFieldOffset,  长度字段 的 偏移量
 * int lengthFieldLength,  长度字段 本身长度
 * int lengthAdjustment,   长度字段 为基准，跳过几个字节 才是内容
 * int initialBytesToStrip 从头剥离 几个字节，解析后将不出现
 * )
 */
@Slf4j
public class Server {
    void start() {
        final NioEventLoopGroup boss = new NioEventLoopGroup();
        final NioEventLoopGroup worker = new NioEventLoopGroup();
        try {
            final ServerBootstrap bs = new ServerBootstrap();
            bs.channel(NioServerSocketChannel.class);
            bs.group(boss, worker);
            bs.childHandler(new ChannelInitializer<SocketChannel>() {
                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    // 解码器 【以下参数 要和 客户端约定好 】
                    ch.pipeline().addLast(
                            new LengthFieldBasedFrameDecoder(
                                    1024, 0, 4, 3, 7)
                    );
                    ch.pipeline().addLast(new LoggingHandler(LogLevel.DEBUG));
                    ch.pipeline().addLast(new ChannelInboundHandlerAdapter() {
                        @Override
                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            ByteBuf buf = (ByteBuf) msg;
                            System.out.println("有信息进来了。。。。");
                            log.debug(buf.toString(Charset.defaultCharset()));
                        }
                    });
                }
            });
            final ChannelFuture channelFuture = bs.bind(8080).sync();
            channelFuture.channel().closeFuture().sync();
        } catch (InterruptedException e) {
            log.error("server error", e);
        } finally {
            boss.shutdownGracefully();
            worker.shutdownGracefully();
        }
    }

    public static void main(String[] args) {
        new Server().start();
    }
}