package com.kwan.shuyu.netty_05_io;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class OIOClient {
    public static final String[] commands = new String[]{
            "hi",
            "i am client",
            "helloworld",
            "java and netty"
    };

    public static void main(String[] args) throws IOException {
        int concurrent = 1;
        Runnable task = () -> {
            try {
                Socket socket = new Socket("127.0.0.1", 8084);
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                /**
                 *  HEADER(2)|LENGTH(2)|BODY
                 *  LENGTH = (self(2) + BODY),  not include header
                 */
                for (String str : commands) {
                    out.writeByte('A');
                    out.writeByte('W');
                    int length = str.length();
                    out.writeShort(length * 2 + 2);//why *2 here?
                    out.writeChars(str);
                }
                out.flush();
                BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String line = null;
                while (!((line = br.readLine()) == null)) {
                    System.out.println(line);
                }
                socket.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        };
        for (int i = 0; i < concurrent; i++) {
            new Thread(task).start();
        }
    }
}