package com.kwan.shuyu.netty_03_nio.c8_aio;

import com.kwan.shuyu.until.ByteBufferUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

/**
 * 异步传输文件
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/21 18:37
 */
@Slf4j
public class AioFileChannel {
    public static void main(String[] args) throws IOException {
        AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get("data.txt"), StandardOpenOption.READ);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        channel.read(buffer, 0, buffer, new CompletionHandler<Integer, ByteBuffer>() {
            @Override
            public void completed(Integer result, ByteBuffer attachment) {
                log.info("read completed....{}", result);
                attachment.flip();
                ByteBufferUtil.debugAll(attachment);
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                exc.printStackTrace();
            }
        });
        System.in.read();
    }
}