package com.kwan.shuyu.netty_03_nio.c3_Selector;

import com.kwan.shuyu.until.ByteBufferUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

/**
 * NioServer 服务端
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 18:22
 */
@Slf4j
public class NioServer {
    public static void main(String[] args) throws IOException {
        final Selector selector = Selector.open();
        //预设ByteBuffer,并分配空间,为了读取数据
        final ByteBuffer buffer = ByteBuffer.allocate(16);
        //创建ServerSocketChannel
        final ServerSocketChannel ssc = ServerSocketChannel.open();
        //绑定端口号
        ssc.configureBlocking(false);
        //ServerSocketChannel注册到Selector中
        final SelectionKey sscKey = ssc.register(selector, 0, null);
        sscKey.interestOps(SelectionKey.OP_ACCEPT);
        log.info("sscKey={}", sscKey);
        ssc.bind(new InetSocketAddress(8080));
        while (true) {
            //select方法,没有事件发生,线程阻塞,有事件,线程才会恢复运行
            //select在事件未处理时,它不会阻塞,会一直请求处理
            selector.select();
            final Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                final SelectionKey key = iterator.next();
                iterator.remove();
                log.info("key={}", key);
                if (key.isAcceptable()) {
                    final ServerSocketChannel channel = (ServerSocketChannel) key.channel();
                    final SocketChannel sc = channel.accept();
                    sc.configureBlocking(false);
                    final SelectionKey scKey = sc.register(selector, 0, null);
                    scKey.interestOps(SelectionKey.OP_READ);
                    log.info("sc={}", sc);
                    log.info("scKey={}", scKey);
                } else if (key.isReadable()) {
                    try {
                        final SocketChannel channel = (SocketChannel) key.channel();
                        ByteBuffer bf = ByteBuffer.allocate(16);
                        final int read = channel.read(bf);
                        if (read == -1) {
                            key.cancel();
                        } else {
                            bf.flip();
                            ByteBufferUtil.debugRead(bf);
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        key.cancel();//取消事件处理
                    }
                }
            }
        }
    }
}