package com.kwan.shuyu.netty_02_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * 拷贝一个文件夹中的数据到另一个文件夹(有子文件夹)
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class File_10_Test_copy {
    public static void main(String[] args) throws IOException {
        String from = "/Users/qinyingjie/Documents/idea-workspace/netty-demo";
        String to = "/Users/qinyingjie/Downloads/未命名文件夹";
        Files.walk(Paths.get(from)).forEach(path -> {
            try {
                String targetName = path.toString().replace(from, to);
                if (Files.isDirectory(path)) {
                    Files.createDirectories(Paths.get(targetName));
                }
                if (Files.isRegularFile(path)) {
                    Files.copy(path, Paths.get(targetName));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}