package com.kwan.shuyu.old;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class Reactor {
    interface ChannelHandler {
        void onRead(SocketChannel channel) throws Exception;

        void onAccept();
    }

    private static ChannelHandler echo = new ChannelHandler() {
        @Override
        public void onRead(SocketChannel socket) throws IOException {
            final ByteBuffer buffer = ByteBuffer.allocate(256);
            final int bytesRead = socket.read(buffer);
            if (bytesRead > 0) {
                buffer.flip();
                socket.write(buffer);
                buffer.clear();
            } else if (bytesRead < 0) {
                socket.close();
                System.out.println("Client close");
            }
        }

        @Override
        public void onAccept() {
        }
    };

    public static void start(int port) throws Exception {
        final ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        InetSocketAddress address = new InetSocketAddress(port);
        //bind & listen
        serverChannel.bind(address);
        final Selector selector = Selector.open();
        SelectionKey sk = serverChannel.register(selector, SelectionKey.OP_ACCEPT);
        sk.attach(new ChannelHandler() {//Acceptor
            @Override
            public void onRead(SocketChannel channel) {
            }

            @Override
            public void onAccept() {
                try {
                    SocketChannel socket = serverChannel.accept();
                    System.out.println("Accept !");
                    socket.configureBlocking(false);
                    SelectionKey sk = socket.register(selector, 0);//register op_read here is also ok in single thread
                    sk.attach(echo);
                    sk.interestOps(SelectionKey.OP_READ);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        while (true) {
            selector.select();
            Set<SelectionKey> readyKeys = selector.selectedKeys();
            Iterator<SelectionKey> it = readyKeys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                ChannelHandler handler = (ChannelHandler) key.attachment();
                //accept
                if (key.isAcceptable()) {
                    handler.onAccept();
                }
                if (key.isReadable()) {
                    handler.onRead((SocketChannel) key.channel());
                }
                it.remove();//don't forget
            }
        }
    }

    public static void main(String[] args) throws Exception {
        start(8084);
    }
}