package com.kwan.shuyu.heima.netty_04_netty.c3_channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringEncoder;

import java.net.InetSocketAddress;


/**
 * Channel
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/23 16:43
 */
public class TestEventLoop_02_Client {
    public static void main(String[] args) throws InterruptedException {
        //1.启动类
        final Channel channel = new Bootstrap()
                // 2.添加 EventLoop
                .group(new NioEventLoopGroup())
                //3.选择客户端channel实现
                .channel(NioSocketChannel.class)
                // 4.添加处理器
                .handler(new ChannelInitializer<NioSocketChannel>() {
                    @Override //在连接建立后被调用
                    protected void initChannel(NioSocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new StringEncoder());
                    }
                })
                //连接到服务器
                .connect(new InetSocketAddress("localhost", 8080))
                .sync()
                .channel();
        //发送数据
        channel.writeAndFlush("hello world");

    }
}