package com.kwan.shuyu.heima.netty_03_nio.c1_阻塞;

import com.kwan.shuyu.until.ByteBufferUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;


/**
 * NioServer 服务端 单线程模拟阻塞模式
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 18:22
 */
@Slf4j
public class NioServer {
    public static void main(String[] args) throws IOException {
        //预设ByteBuffer,并分配空间,为了读取数据
        final ByteBuffer buffer = ByteBuffer.allocate(16);
        //创建ServerSocketChannel
        final ServerSocketChannel ssc = ServerSocketChannel.open();
        //绑定端口号
        ssc.bind(new InetSocketAddress(8080));
        //保存SocketChannel集合
        List<SocketChannel> channels = new ArrayList<>();
        while (true) {
            log.info("connecting......");
            //等待建立连接
            final SocketChannel sc = ssc.accept();
            log.info("connected....  {}", sc);
            //建立连接后加入集合
            channels.add(sc);
            //遍历channels集合
            for (SocketChannel channel : channels) {
                log.info("before read....  {}", channel);
                //读取ByteBuffer内容
                channel.read(buffer);
                //切换为读模式
                buffer.flip();
                ByteBufferUtil.debugRead(buffer);
                //切换为写模式
                buffer.clear();
                log.info("alfter read....  {}", channel);
            }
        }
    }
}
