package com.kwan.shuyu.kuangshen.lesson6;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.net.DatagramPacket;
import java.net.DatagramSocket;


/**
 * 多线程接收
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/19 12:16
 */

@Slf4j
public class TalkReceive implements Runnable {
    private DatagramSocket socket;
    private final int port;
    private final String msgFrom;

    @SneakyThrows
    public TalkReceive(int port, String msgFrom) {
        this.port = port;
        this.msgFrom = msgFrom;
        this.socket = new DatagramSocket(port);
    }

    @SneakyThrows
    @Override
    public void run() {
        //1.创建socket
        while (true) { //2.接收数据包
            final byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
            socket.receive(packet);
            //断开连接 bye
            final byte[] data = packet.getData();
            final String receive = new String(data, 0, packet.getLength());
            log.info(msgFrom + ": " + receive);
            if (StringUtils.equalsIgnoreCase(receive, "bye")) {
                break;
            }
        }
        //3.关闭资源
        socket.close();
    }
}
