package com.kwan.shuyu.heima.netty_03_nio.c7_optimization;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;


/**
 * NioClient 客户端
 * <p>
 * 发消息:sc.write(Charset.defaultCharset().encode("hi!"))
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 18:22
 */
public class NioClient {
    public static void main(String[] args) throws IOException {
        //创建SocketChannel
        SocketChannel sc = SocketChannel.open();
        //建立和服务端的连接
        sc.connect(new InetSocketAddress("localhost", 8080));
        int count = 0;
        while (true) {
            final ByteBuffer byteBuffer = ByteBuffer.allocate(1024 * 1024);
            count += sc.read(byteBuffer);
            System.out.println(count);
            byteBuffer.clear();
        }
    }
}
