package com.kwan.shuyu.heima.netty_02_file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 * 将一个文件中的数据复制到另一个文件 传多次
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class File_05_Test_transferTo {
    public static void main(String[] args) {
        try (final FileChannel from = new FileInputStream("data.txt").getChannel();
             final FileChannel to = new FileOutputStream("to.txt").getChannel();
        ) {
            final long size = from.size();
            //left代表还剩多少字节
            for (long left = size; left > 0; ) {
                left -= from.transferTo((size - left), left, to);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}