package com.kwan.shuyu.kuangshen.lesson7;

import lombok.extern.slf4j.Slf4j;

import java.net.URL;

/**
 * URL常用方法解析
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/19 12:37
 */
@Slf4j
public class UrlDemo {
    public static void main(String[] args) throws Exception {
        final URL url = new URL("http://localhost:8080/helloworld/index.jsp?username=kuangshen&password=123");
        log.info(url.getAuthority());//localhost:8080
        log.info(url.getPath());///helloworld/index.jsp
        log.info(url.getProtocol());//http
        log.info(url.getHost());//localhost
        log.info(url.getFile());///helloworld/index.jsp?username=kuangshen&password=123
        log.info(url.getUserInfo());//null
        log.info(url.getQuery());//username=kuangshen&password=123
        log.info(url.getRef());//null
        log.info(String.valueOf(url.getDefaultPort()));//80
        log.info((String) url.getContent());
    }
}
