package com.kwan.shuyu.kuangshen.lesson6;

import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;


/**
 * 多线程发送
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/19 12:16
 */
public class TalkSend implements Runnable {
    DatagramSocket socket;
    BufferedReader reader;
    private final int fromPort;
    private final String toIp;
    private final int toPort;

    public TalkSend(int fromPort, String toIp, int toPort) throws Exception {
        this.fromPort = fromPort;
        this.toIp = toIp;
        this.toPort = toPort;
        //1.创建一个socket
        this.socket = new DatagramSocket(fromPort);
        //2.控制台输入
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    @SneakyThrows
    @Override
    public void run() {
        while (true) {
            final String data = reader.readLine();
            final byte[] datas = data.getBytes();
            final DatagramPacket packet = new DatagramPacket(datas, 0, datas.length, new InetSocketAddress(this.toIp, this.toPort));
            //3.发送
            socket.send(packet);
            if (StringUtils.equalsIgnoreCase(data, "bye")) {
                break;
            }
        }
        //4.关闭资源
        socket.close();
    }
}
