package com.kwan.shuyu.kuangshen.lesson5;

import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

/**
 * 发送端 udp
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/19 11:24
 */
public class Chat_001_send {
    public static void main(String[] args) throws Exception {
        //1.创建一个socket
        DatagramSocket socket = new DatagramSocket(8888);
        //2.控制台输入
        final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            final String data = reader.readLine();
            final byte[] datas = data.getBytes();
            final DatagramPacket packet = new DatagramPacket(datas, 0, datas.length, new InetSocketAddress("localhost", 6666));
            //3.发送
            socket.send(packet);
            if (StringUtils.equalsIgnoreCase(data, "bye")) {
                break;
            }
        }
        //4.关闭资源
        socket.close();
    }
}