package com.kwan.shuyu.kuangshen.lesson1;

import lombok.extern.slf4j.Slf4j;

import java.net.InetAddress;

/**
 * InetAddress类解读
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/18 14:15
 */
@Slf4j
public class Basic_001_InetAddress {
    public static void main(String[] args) throws Exception {
        //获取本机地址信息
        InetAddress localIp = InetAddress.getLocalHost();
        log.info("localIp.getCanonicalHostName()=" + localIp.getCanonicalHostName());//localhost
        log.info("localIp.getHostAddress()=" + localIp.getHostAddress());//127.0.0.1
        log.info("localIp.getHostName()=" + localIp.getHostName());//qinyingjiedeMacBook-Pro.local
        log.info("localIp.toString()=" + localIp.toString());//qinyingjiedeMacBook-Pro.local/127.0.0.1
        log.info("localIp.isReachable(5000)=" + localIp.isReachable(3000));//true
        //获取指定域名地址信息
        log.info("====================================");
        InetAddress baiduIp = InetAddress.getByName("www.baidu.com");
        log.info("baiduIp.getCanonicalHostName()=" + baiduIp.getCanonicalHostName());//14.119.104.189
        log.info("baiduIp.getHostAddress()=" + baiduIp.getHostAddress());//14.119.104.189
        log.info("baiduIp.getHostName()=" + baiduIp.getHostName());//www.baidu.com
        log.info("baiduIp.toString()=" + baiduIp.toString());//www.baidu.com/14.119.104.189
        log.info("baiduIp.isReachable(5000)=" + baiduIp.isReachable(5000));//false
        log.info("====================================");
        //获取指定原始IP地址信息
        InetAddress ip = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        log.info("ip.getCanonicalHostName()=" + ip.getCanonicalHostName());//localhost
        log.info("ip.getHostAddress()= " + ip.getHostAddress());//127.0.0.1
        log.info("ip.getHostName()=" + ip.getHostName());//localhost
        log.info("ip.toString()=" + ip.toString());//localhost/127.0.0.1
        log.info("ip.isReachable(5000)=" + ip.isReachable(5000));//true
    }
}