package com.kwan.shuyu.heima.netty_07_bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import lombok.extern.slf4j.Slf4j;

import static io.netty.buffer.ByteBufUtil.appendPrettyHexDump;
import static io.netty.util.internal.StringUtil.NEWLINE;

/**
 * ByteBuf的slice
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/27 09:34
 */
@Slf4j
public class ByteBuf_08 {

    public static void main(String[] args) {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(10);
        buffer.writeBytes(new byte[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'});
        log(buffer);
        final ByteBuf slice1 = buffer.slice(0, 5);
        slice1.retain();
        final ByteBuf slice2 = buffer.slice(0, 5);
        slice2.retain();
        log(slice1);
        log(slice2);

        /**
         * read index:0 write index:10 capacity:10
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 61 62 63 64 65 66 67 68 69 6a                   |abcdefghij      |
         * +--------+-------------------------------------------------+----------------+
         * read index:0 write index:5 capacity:5
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 61 62 63 64 65                                  |abcde           |
         * +--------+-------------------------------------------------+----------------+
         * read index:0 write index:5 capacity:5
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 61 62 63 64 65                                  |abcde           |
         * +--------+-------------------------------------------------+----------------+
         */
        slice1.setByte(0, 'b');
        log(buffer);
        log(slice1);
        /**
         * read index:0 write index:10 capacity:10
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 62 62 63 64 65 66 67 68 69 6a                   |bbcdefghij      |
         * +--------+-------------------------------------------------+----------------+
         * read index:0 write index:5 capacity:5
         *          +-------------------------------------------------+
         *          |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |
         * +--------+-------------------------------------------------+----------------+
         * |00000000| 62 62 63 64 65                                  |bbcde           |
         * +--------+-------------------------------------------------+----------------+
         */
        buffer.release();
        log(slice1);
        /**
         * Exception in thread "main" io.netty.util.IllegalReferenceCountException: refCnt: 0
         * 	at io.netty.buffer.AbstractByteBuf.ensureAccessible(AbstractByteBuf.java:1454)
         * 	at io.netty.buffer.AbstractByteBuf.checkIndex(AbstractByteBuf.java:1383)
         * 	at io.netty.buffer.AbstractByteBuf.checkIndex(AbstractByteBuf.java:1379)
         * 	at io.netty.buffer.AbstractByteBuf.getByte(AbstractByteBuf.java:355)
         * 	at io.netty.buffer.AbstractUnpooledSlicedByteBuf.getByte(AbstractUnpooledSlicedByteBuf.java:120)
         * 	at io.netty.buffer.AbstractByteBuf.getUnsignedByte(AbstractByteBuf.java:368)
         * 	at io.netty.buffer.ByteBufUtil$HexUtil.appendPrettyHexDump(ByteBufUtil.java:1580)
         * 	at io.netty.buffer.ByteBufUtil$HexUtil.access$500(ByteBufUtil.java:1420)
         * 	at io.netty.buffer.ByteBufUtil.appendPrettyHexDump(ByteBufUtil.java:1416)
         * 	at io.netty.buffer.ByteBufUtil.appendPrettyHexDump(ByteBufUtil.java:1407)
         * 	at com.kwan.shuyu.heima.netty_07_bytebuf.ByteBuf_08.log(ByteBuf_08.java:79)
         * 	at com.kwan.shuyu.heima.netty_07_bytebuf.ByteBuf_08.main(ByteBuf_08.java:67)
         */

    }

    private static void log(ByteBuf buffer) {
        int length = buffer.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder buf = new StringBuilder(rows * 80 * 2)
                .append("read index:").append(buffer.readerIndex())
                .append(" write index:").append(buffer.writerIndex())
                .append(" capacity:").append(buffer.capacity())
                .append(NEWLINE);
        appendPrettyHexDump(buf, buffer);
        System.out.println(buf.toString());
    }
}
