package com.kwan.shuyu.heima.netty_05_future;

import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.Callable;

/**
 * netty Future 测试
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/26 21:07
 */
@Slf4j
public class TestNettyFuture {
    public static void main(String[] args) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        EventLoop eventLoop = group.next();
        Future<Integer> future = eventLoop.submit(new Callable<Integer>() {
            @Override
            public Integer call() throws Exception {
                log.info("执行计算");
                Thread.sleep(1000);
                return 78;
            }
        });
        //3.主线程通过future 来获取结果
        log.info("等待处理结果");
        log.info("处理结果是={}", future.get());
    }
}