package com.kwan.shuyu.heima.netty_04_netty.c1_basic;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;


/**
 * 服务端ChannelInboundHandlerAdapter自定义handler
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/23 16:42
 */
public class HelloServer {
    public static void main(String[] args) {
        //启动器,负责组装netty组件
        new ServerBootstrap()
                //BossEventLoop,WorkerEventLoop(selector,thread),group组
                .group(new NioEventLoopGroup())
                //选择服务器的ServerSocketChannel实现
                .channel(NioServerSocketChannel.class)
                //boss负责处理连接 worker（child)负责处理读写，决定了worker（child)能执行哪些操作（handler)
                .childHandler(
                        //channel代表和客户端进行数据读写的通道Initializer初始化
                        new ChannelInitializer<NioSocketChannel>() {
                            @Override
                            protected void initChannel(NioSocketChannel ch) throws Exception {
                                //添加具体的Handler
                                ch.pipeline().addLast(new StringDecoder());//将ByteBuffer转为字符串
                                ch.pipeline().addLast(new ChannelInboundHandlerAdapter() {//自定义Handler
                                    @Override//读事件
                                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                        System.out.println(msg);
                                    }
                                });
                            }
                        }).bind(8080);
    }
}