package com.kwan.shuyu.heima.netty_04_netty.c13_closefeature;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.Charset;

/**
 * 服务端3个Handler
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/23 10:51
 */
@Slf4j
public class TestEventLoop_01_server {
    public static void main(String[] args) {
        //普通任务
        final EventLoopGroup group = new DefaultEventLoopGroup();
        new ServerBootstrap()
                //boss 只负责ServerSocketChannel 上 accept 事件  worker只负责socketChannel上的读写
                .group(new NioEventLoopGroup(), new NioEventLoopGroup(2))
                .channel(NioServerSocketChannel.class)
                .childHandler(new ChannelInitializer<NioSocketChannel>() {
                    @Override
                    protected void initChannel(NioSocketChannel ch) throws Exception {
                        //支持链式调用
                        ch.pipeline().addLast("handler1", new ChannelInboundHandlerAdapter() {
                            // ByteBuf
                            @Override
                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                ByteBuf buf = (ByteBuf) msg;
                                log.info("我是handler1,{}", buf.toString(Charset.defaultCharset()));
                                ctx.fireChannelRead(msg);
                            }
                        }).addLast(group, "handler2", new ChannelInboundHandlerAdapter() {
                            // handler2 是一个普通任务,第一个参数是EventExecutorGroup,指定group执行
                            @Override
                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                ByteBuf buf = (ByteBuf) msg;
                                log.info("我是handler1,{}", buf.toString(Charset.defaultCharset()));
                            }
                        });
                        //添加解码器
                        ch.pipeline().addLast("handler0", new StringDecoder());
                    }
                })
                .bind(8080);
    }
}