package com.kwan.shuyu.heima.netty_02_file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 * 将一个文件中的数据复制到另一个文件,只传一次
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class File_04_Test_transferTo {
    public static void main(String[] args) {
        long start = System.nanoTime();
        try (final FileChannel from = new FileInputStream("data.txt").getChannel();
             final FileChannel to = new FileOutputStream("to.txt").getChannel();
        ) {
            final long size = from.size();
            //效率高，底层会利用操作系统的季零拷贝进行优化
            from.transferTo(0, size, to);

        } catch (IOException e) {
            e.printStackTrace();
        }
        long end = System.nanoTime();
        System.out.println("transferTo 用时:" + (end - start) / 1000_000.0);
    }
}