package com.kwan.shuyu.heima.netty_01_bytebuffer;

import java.nio.ByteBuffer;

import static com.kwan.shuyu.until.ByteBufferUtil.debugAll;

/**
 * 分割数据
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class ByteBuffer_13_Test_split {
    public static void main(String[] args) {
        final ByteBuffer source = ByteBuffer.allocate(32);
        source.put("Hello, world\nI'm zhangsan \nho".getBytes());
        split(source);
        source.put("w are you?\n".getBytes());
        split(source);
    }

    private static void split(ByteBuffer source) {
        source.flip();
        final int limit = source.limit();
        for (int i = 0; i < limit; i++) {
            //找到完整的消息
            if (source.get(i) == '\n') {
                final int len = i + 1 - source.position();
                final ByteBuffer target = ByteBuffer.allocate(len);
                for (int j = 0; j < len; j++) {
                    //从source读取,向target写入
                    target.put(source.get());
                }
                debugAll(target);
            }
        }
        source.compact();
    }
}