package com.kwan.shuyu.heima.netty_01_bytebuffer;

import com.kwan.shuyu.until.ByteBufferUtil;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * 分散读取
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 18:01
 */
public class ByteBuffer_11_Test_Read {
    public static void main(String[] args) {
        try (RandomAccessFile file = new RandomAccessFile("3parts.txt", "rw")) {
            FileChannel channel = file.getChannel();
            ByteBuffer a = ByteBuffer.allocate(3);
            ByteBuffer b = ByteBuffer.allocate(3);
            ByteBuffer c = ByteBuffer.allocate(5);
            channel.read(new ByteBuffer[]{a, b, c});
            a.flip();
            b.flip();
            c.flip();
            ByteBufferUtil.debugRead(a);
            ByteBufferUtil.debugRead(b);
            ByteBufferUtil.debugRead(c);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
