package com.kwan.shuyu.heima.netty_01_bytebuffer;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * ByteBuffer读取文件内容
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/4/18 17:15
 */
public class ByteBuffer_01_Test_FileChannel {
    public static void main(String[] args) {
        try (FileChannel channel = new FileInputStream("data.txt").getChannel()) {
            ByteBuffer buffer = ByteBuffer.allocate(10);
            channel.read(buffer);
            buffer.flip();
            while (buffer.hasRemaining()) {
                final byte b = buffer.get();
                System.out.println((char) b);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
