package cn.itcast.article.service;

import cn.itcast.article.po.Comment;
import com.alibaba.fastjson2.JSON;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.domain.Page;
import org.springframework.test.context.junit4.SpringRunner;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
public class CommentServiceTest {
    @Autowired
    private CommentService commentService;

    /**
     * 查询所有文档
     */
    @Test
    public void testFindCommentList() {
        List<Comment> commentList = commentService.findCommentList();
        log.info(JSON.toJSONString(commentList));
    }

    /**
     * 根据id查询
     */
    @Test
    public void testFindCommentById() {
        Comment commentById = commentService.findCommentById("1");
        log.info(JSON.toJSONString(commentById));
    }

    /**
     * 新增评论
     */
    @Test
    public void testSaveComment() {
        Comment comment = new Comment();
        comment.setArticleid("100000");
        comment.setContent("测试添加的数据");
        comment.setCreatedatetime(LocalDateTime.now());
        comment.setUserid("1003");
        comment.setNickname("凯撒大帝");
        comment.setState("1");
        comment.setLikenum(0);
        comment.setReplynum(0);
        commentService.saveComment(comment);
    }

    /**
     * 根据parentid分页查询
     */
    @Test
    public void testFindCommentListByUserid() {
        Page<Comment> page = commentService.findByUserid("1003", 1, 10);
        log.info(JSON.toJSONString(page.getTotalElements()));
        log.info(JSON.toJSONString(page.getContent()));
    }

    /**
     * 多字段查询
     */
    @Test
    public void testFindCommentListByUseridAndLikenum() {
        Page<Comment> page = commentService.findByUseridAndLikenum("1003", 3000, 1, 2);
        log.info(JSON.toJSONString(page.getTotalElements()));
        log.info(JSON.toJSONString(page.getContent()));
    }

    /**
     * 分页多字段查询,并且
     * 查询userid固定值,并且likenum大于等于的文档
     */
    @Test
    public void testFindByUseridContainingAndLikenumGreaterThanEqual() {
        Page<Comment> page = commentService.findByUseridContainingAndLikenumGreaterThanEqual("1003", 100, 1, 2);
        log.info(JSON.toJSONString(page.getTotalElements()));
        log.info(JSON.toJSONString(page.getContent()));
    }

    /**
     * 正则查询
     */
    @Test
    public void testFindByUseridAndLikenum() {
        List<Comment> list = commentService.findByUseridAndLikenum("1003", 100);
        log.info(JSON.toJSONString(list));
    }

    /**
     * 修改点赞数加1
     */
    @Test
    public void testUpdateCommentLikenum() {
        commentService.updateCommentLikenum("1");
    }
}