package cn.itcast.article.service;

import cn.itcast.article.dao.CommentRepository;
import cn.itcast.article.po.Comment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CommentService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CommentRepository commentRepository;

    /**
     * 保存一个评论
     *
     * @param comment
     */
    public void saveComment(Comment comment) {
        //如果需要自定义主键，可以在这里指定主键；如果不指定主键，MongoDB会自动生成主键
        //设置一些默认初始值。。。
        //调用dao
        commentRepository.save(comment);
    }

    /**
     * 更新评论
     *
     * @param comment
     */
    public void updateComment(Comment comment) {
        //调用dao
        commentRepository.save(comment);
    }

    /**
     * 根据id删除评论
     *
     * @param id
     */
    public void deleteCommentById(String id) {
        //调用dao
        commentRepository.deleteById(id);
    }

    /**
     * 查询所有评论
     *
     * @return
     */
    public List<Comment> findCommentList() {
        //调用dao
        return commentRepository.findAll();
    }

    /**
     * 根据id查询评论
     *
     * @param id
     * @return
     */
    public Comment findCommentById(String id) {
        //调用dao
        return commentRepository.findById(id).get();
    }

    public Page<Comment> findByUserid(String userid, int page, int size) {
        return commentRepository.findByUserid(userid, PageRequest.of(page - 1, size));
    }

    public void updateCommentLikenum(String id) {
        //  查询条件
        Query query = Query.query(Criteria.where("_id").is(id));
        //  更新条件
        Update update = new Update();
        update.inc("likenum");
        mongoTemplate.updateFirst(query, update, Comment.class);
    }

    public Page<Comment> findByUseridAndLikenum(String userid, int likenum, int page, int size) {
        return commentRepository.findByUseridAndLikenum(userid, likenum, PageRequest.of(page - 1, size));
    }

    public Page<Comment> findByUseridContainingAndLikenumGreaterThanEqual(String userid, int likenum, int page, int size) {
        return commentRepository.findByUseridContainingAndLikenumGreaterThanEqual(userid, likenum, PageRequest.of(page - 1, size));
    }

    public List<Comment> findByUseridAndLikenum(String userid, int likenum) {
        return commentRepository.findByUseridAndLikenum(userid, likenum);
    }
}