package cn.itcast.article.dao;

import cn.itcast.article.po.Comment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import java.util.List;

public interface CommentRepository extends MongoRepository<Comment, String> {
    /**
     * findByUserid的Userid一定要和参数一致
     *
     * @param userid
     * @param pageable
     * @return
     */
    Page<Comment> findByUserid(String userid, Pageable pageable);

    /**
     * 多字段查询
     *
     * @param userid
     * @param likenum
     * @param pageable
     * @return
     */
    Page<Comment> findByUseridAndLikenum(String userid, Integer likenum, Pageable pageable);

    /**
     * 查询userid固定值,并且likenum大于等于的文档
     *
     * @param userid
     * @param likenum
     * @param pageable
     * @return
     */
    Page<Comment> findByUseridContainingAndLikenumGreaterThanEqual(String userid, Integer likenum, Pageable pageable);


    /**
     * 正则查询
     * 使用了@Query注解来指定查询语句。在查询语句中，
     * 使用了$regex操作符表示name匹配正则表达式，使用了$options选项表示不区分大小写，使用了$gte操作符表示age大于等于指定值。
     *
     * @param userid
     * @param likenum
     * @return
     */
    @Query("{ 'userid' : { $regex: ?0, $options: 'i' }, 'likenum' : { $gte: ?1 } }")
    List<Comment> findByUseridAndLikenum(String userid, Integer likenum);
}