package com.kwan.shuyu.controller;

import com.kwan.shuyu.pojo.Payload;
import com.kwan.shuyu.service.UserService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/user")
public class UserController {

    @DubboReference(interfaceClass = UserService.class, check = false)
    private UserService userService;

    @RequestMapping("/count")
    public Payload<String> getCount() {
        int count = userService.getCount();
        return new Payload("当前在线的人数为:" + count);
    }
}
