package com.kwan.shuyu.pojo;

import com.kwan.shuyu.enums.ResultConstant;

import java.io.Serializable;

/**
 * 结果集
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/3/13 14:45
 */
public class Payload<T> implements Serializable {
    private static final long serialVersionUID = -1549643581827130116L;
    private T payload;
    private String code;
    private String msg;

    public Payload() {
        this.code = ResultConstant.SUCCESS.getCode();
        this.msg = ResultConstant.SUCCESS.getMsg();
    }

    public Payload(T payload) {
        this.code = ResultConstant.SUCCESS.getCode();
        this.msg = ResultConstant.SUCCESS.getMsg();
        this.payload = payload;
    }

    public Payload(String code, String msg) {
        this.code = ResultConstant.SUCCESS.getCode();
        this.msg = ResultConstant.SUCCESS.getMsg();
        this.code = code;
        this.msg = msg;
    }

    public Payload(T payload, String code, String msg) {
        this.code = ResultConstant.SUCCESS.getCode();
        this.msg = ResultConstant.SUCCESS.getMsg();
        this.payload = payload;
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getPayload() {
        return this.payload;
    }

    public boolean success() {
        return this.getCode().equals("0");
    }
}