# JavaScript

[https://github.com/ryanmcdermott/clean-code-javascript](https://github.com/ryanmcdermott/clean-code-javascript) Clean Code concepts adapted for JavaScript

[TypeScript 中文手册](https://typescript.bootcss.com/)

[ES6 入门教程(阮一峰)](https://es6.ruanyifeng.com/)

## 第三方库

[Vue.js](/doc/vue.md)

[React.js](https://reactjs.org/): A JavaScript library for building user interfaces

- [Ant Design](https://ant.design/index-cn): 一套企业级 UI 设计语言和 React 组件库

[alasql](http://alasql.org/)

[xijs](http://h5.dooring.cn/xijs/): 一款面向复杂业务场景的 javascript 工具库

[jQuery](https://jquery.com/)

- [jQuery API 3.5.1 速查表](https://jquery.cuishifeng.cn/)

- [jQuery 教程](https://www.w3school.com.cn/jquery/index.asp): 极大地简化了 JavaScript 编程

- [Jquery EasyUI](https://www.jeasyui.net/): 帮助 web 开发者更轻松的打造出功能丰富并且美观的 UI 界面

- [bxslider](https://bxslider.com/): Add a slider to any webpage. -[jQuery 插件库](https://www.jq22.com/): 收集最全最新最好的 jQuery 插件

- [jQuery jsonp 跨域请求](https://www.cnblogs.com/chiangchou/p/jsonp.html)

- [jquery 和 vue 对比](https://www.cnblogs.com/MR-YY/p/6898464.html)

- [jQuery 之家 ](http://www.htmleaf.com/): 免费提供各种前端开发所需要的 JQUERY、HTML5、CSS3 等优质插件素材

[Apache ECharts](https://echarts.apache.org/zh/index.html): 一个基于 JavaScript 的开源可视化图表库

- [ECharts 示例](https://echarts.apache.org/examples/zh/index.html)

[UIkit](https://getuikit.com/): A lightweight and modular front-end framework for developing fast and powerful web interfaces.

[html2canvas](http://html2canvas.hertzen.com/): Screenshots with JavaScript

[Uni API](https://universal-api.js.org/): 小程序容器和 Web 容器的跨端 API 解决方案

[Pinia](https://pinia.vuejs.org/): The Vue Store that you will enjoy using

[Sails.js](https://sailsjs.com/)The MVC framework for Node.js

[iView UI](https://iviewui.com/docs/guide/install): 一套基于 Vue.js 的高质量 UI 组件库

[Vant 2](https://vant-contrib.gitee.io/vant/v2/#/zh-CN/) 轻量、可靠的移动端 Vue 组件库

[Swiper](https://www.swiper.com.cn/)(Swiper master)是目前应用较广泛的移动端网页触摸内容滑动 js 插件

[Moment.js](http://momentjs.cn/) JavaScript 日期处理类库

[Lodash](https://www.lodashjs.com/)一个一致性、模块化、高性能的 JavaScript 实用工具库。

[rollup.js 中文文档](https://www.rollupjs.com/) 一个 JavaScript 模块打包器

[CKEditor](https://ckeditor.com/docs/index.html) Smart rich text editor components with collaborative editing.

[wangEditor 5](https://www.wangeditor.com/): 开源 Web 富文本编辑器，开箱即用，配置简单

[ScrollReveal](https://scrollrevealjs.org/)

[preactjs](https://preactjs.com/)Fast 3kB alternative to React with the same modern API.

[node-qrcode](https://github.com/soldair/node-qrcode) QR code/2d barcode generator.

[QRCode.js](https://github.com/davidshimjs/qrcodejs): Cross-browser QRCode generator for javascript

[vue-qriously](https://github.com/theomessin/vue-qriously)：A Vue.js 2 component to draw QR codes on an HTML Canvas using qrious.

[qrious](https://github.com/neocotic/qrious): Pure JavaScript library for QR code generation using canvas

[deepmerge](https://github.com/TehShrike/deepmerge) | [npm](https://www.npmjs.com/package/deepmerge) : A library for deep (recursive) merging of Javascript objects

[throttle-debounce](https://github.com/niksy/throttle-debounce) | [npm](https://www.npmjs.com/package/throttle-debounce): Throttle and debounce functions.

[async-validator](https://github.com/yiminghe/async-validator) | [npm](https://www.npmjs.com/package/async-validator) : Validate form asynchronous

[portal-vue](https://github.com/linusborg/portal-vue): A Portal Component for Vuejs, to render DOM outside of a component, anywhere in the document.

[V-Calendar](https://vcalendar.io/) An elegant calendar and datepicker plugin for Vuejs.

[Draft.js](https://draftjs.org/) Rich Text Editor Framework for React

[vue-codemirror](https://github.com/surmon-china/vue-codemirror) @codemirror code editor component for @vuejs

[vue-local-storage](https://github.com/pinguinjkeke/vue-local-storage) Vue.js localStorage plugin with types support

[vue-js-modal](http://vue-js-modal.yev.io/) | [github](https://github.com/euvl/vue-js-modal): Easy to use, highly customizable Vue.js modal library.

[typeahead.js](https://typeahead.js.org/) a flexible JavaScript library that provides a strong foundation for building robust typeaheads

[EJS](https://ejs.bootcss.com/) 高效的嵌入式 JavaScript 模板引擎。

[mavon-editor](https://github.com/hinesboy/mavonEditor) | [npm](https://www.npmjs.com/package/mavon-editor) A markdown editor based on Vue that supports a variety of personalized features

[naming-style](https://github.com/parksben/naming-style) | [npm](https://www.npmjs.com/package/naming-style) | [中文 doc](https://github.com/parksben/naming-style/blob/HEAD/DOC_ZH.md): 变量命名风格转化

## CDN

[BootCDN](https://www.bootcdn.cn/): 稳定、快速、免费的前端开源项目 CDN 加速服务

[jsDelivr](https://www.jsdelivr.com/): A free CDN for Open Source
fast, reliable, and automated

[UNPKG](https://unpkg.com/): a fast, global content delivery network for everything on npm.

[cdnjs](https://cdnjs.com/):Simple. Fast. Reliable.
Content delivery at its finest.

[AdonisJS](https://adonisjs.com/): A fully featured web framework for Node.js

[Fabric.js](http://fabricjs.com/) is a powerful and simple
Javascript HTML5 canvas library

[Prettier.js](https://prettier.io/) Opinionated Code Formatter

[西瓜视频播放器（HTML5）](https://v2.h5player.bytedance.com/) 一款带解析器、能节省流量的 HTML5 视频播放器

[https://prettyhtml.netlify.app/](https://prettyhtml.netlify.app/):[](https://github.com/Prettyhtml/prettyhtml)

cnchar: 功能全面、多端支持的汉字拼音笔画 js 库

- 官网：[https://shiyix.cn/cnchar/](https://shiyix.cn/cnchar/)
- github：[https://github.com/theajack/cnchar](https://github.com/theajack/cnchar)

Hanzi Writer: 汉字书写笔画顺序的描边动画
- 官网：[https://hanziwriter.org/cn/](https://hanziwriter.org/cn/)
- github：[https://github.com/chanind/hanzi-writer](https://github.com/chanind/hanzi-writer)

Make Me a Hanzi：Free, open-source Chinese character data
- 官网：[https://www.skishore.me/makemeahanzi/](https://www.skishore.me/makemeahanzi/)
- github：[https://github.com/skishore/makemeahanzi](https://github.com/skishore/makemeahanzi)


## Node.js

https://npm.devtool.tech/

[ionic 教程](https://www.runoob.com/ionic/ionic-tutorial.html): 一个强大的 HTML5 应用程序开发框架(HTML5 Hybrid Mobile App Framework )

[Express 中文网](https://www.expressjs.com.cn/): 基于 Node.js 平台，快速、开放、极简的 Web 开发框架

[Egg.js](https://www.eggjs.org/zh-CN) 企业级 Node.js 开发框架

### Node.js 管理工具

| 名称                                   | 简介                  | 最近更新                                                                      | 标星                                                                   |
| -------------------------------------- | --------------------- | ----------------------------------------------------------------------------- | ---------------------------------------------------------------------- |
| [nvm](https://github.com/nvm-sh/nvm)   | Node Version Manager  | ![](https://img.shields.io/github/last-commit/nvm-sh/nvm?style=flat-square)   | ![](https://img.shields.io/github/stars/nvm-sh/nvm.svg?style=social)   |
| [nvs](https://github.com/jasongin/nvs) | Node Version Switcher | ![](https://img.shields.io/github/last-commit/jasongin/nvs?style=flat-square) | ![](https://img.shields.io/github/stars/jasongin/nvs.svg?style=social) |

### 包管理工具

npm - a JavaScript package manager

- ![](https://img.shields.io/github/last-commit/npm/cli?style=flat-square)
- ![](https://img.shields.io/github/stars/npm/cli.svg?style=social)
- github [https://github.com/npm/cli](https://github.com/npm/cli)
- [npm 中文文档](https://www.npmjs.cn/)

Yarn： 快速、可靠、安全的依赖管理工具

- ![](https://img.shields.io/github/last-commit/yarnpkg/berry?style=flat-square)
- ![](https://img.shields.io/github/stars/yarnpkg/berry.svg?style=social)
- [https://yarnpkg.com/](https://yarnpkg.com/)
- github: [https://github.com/yarnpkg/berry](https://github.com/yarnpkg/berry)
- Yarn 中文文档: [https://yarn.bootcss.com/](https://yarn.bootcss.com/)
- Yarn 中文文档: [https://www.yarnpkg.cn/](https://www.yarnpkg.cn/)

pNpm：速度快、节省磁盘空间的软件包管理器

- ![](https://img.shields.io/github/last-commit/pnpm/pnpm?style=flat-square)
- ![](https://img.shields.io/github/stars/pnpm/pnpm.svg?style=social)
- [pnpm 中文文档](https://www.pnpm.cn/)

## 文章

[能解决 90% 需求的 js 库](https://juejin.cn/post/7024011415144890405)

[W3School - JavaScript 教程](https://www.w3school.com.cn/js/index.asp)

2021-12-23 [Node.js：fs（file system）文件系统管理模块](https://pengshiyu.blog.csdn.net/article/details/122111586)

2021-12-23 [Pinia：Vue3.js 的状态管理器](https://pengshiyu.blog.csdn.net/article/details/122101558)

2021-12-23 [PubSubJS：用 JavaScript 编写的基于主题的发布/订阅库](https://pengshiyu.blog.csdn.net/article/details/122100104)

[http://www.json.org/](http://www.json.org/)

[https://jekyllthemes.io/](https://jekyllthemes.io/)

[ECMAScript 6 入门 Promise 对象](https://es6.ruanyifeng.com/#docs/promise)

[https://www.ecma-international.org/](https://www.ecma-international.org/)

[vue-element-admin](https://panjiachen.gitee.io/vue-element-admin-site/zh/guide/) 是一个后台前端解决方案，它基于 vue 和 element-ui 实现。

[JSON Web Tokens](https://www.jsonwebtoken.io/) JSON Web Tokens are an open, industry standard RFC 7519 method for representing claims securely between two parties.

[GraphQL](https://graphql.cn/) 一种用于 API 的查询语言
