# Python Web开发实战-个人博客开发

简介：

本书通过学习Python3和Vue3.js基本的知识，利用现有流行的开源库，构建个人博客项目，实现对博客文章的的增、删、改、查，实现一个完整的前后端分离项目。

本书基于写书时最新版本实现

- Python3 3.10.8
- Vue.js 3.2.41

本书分为：服务端和客户端两个部分

第一部分 基于Python3构建服务端包括
- 第二章 Python3 基础
- 第四章 服务端接口API
- 第三章 服务端技术栈
- 第五章 服务端部署

第二部分 基于Vue3.js构建客户端

- 第六章 Vue3.js 基础
- 第七章 客户端技术栈
- 第八章 客户端-后台管理
- 第九章 客户端-前台展示
- 第十章 客户端部署

# 目录

## 第一章 项目说明

- 1.1、需求说明
- 1.2、需求分析
- 1.3、技术可行性

## 第二章 Python3 基础

- 2.1、安装pyenv
- 2.2、安装Python3
- 2.3、开发工具
- 2.4、Python基础语法

## 第三章 服务端技术栈

- 3.1、Web框架 - Flask
- 3.2、开发模式热重载 - gunicorn
- 3.3、数据库ORM - peewee
- 3.4、权限验证 - PyJWT
- 3.5、密码保护 - bcrypt
- 3.6、跨域请求 - Flask-Cors

## 第四章 服务端接口API

- 4.1、登录/退出
- 4.2、博客分类添加
- 4.3、博客分类查询
- 4.4、博客分类修改
- 4.5、博客分类删除
- 4.6、博客添加
- 4.7、博客查询
- 4.8、博客修改
- 4.9、博客删除

## 第五章 服务端部署

- 5.1、后端代码部署 - nginx
- 5.2、后端进程管理 - supervisord

## 第六章 Vue3.js 基础

- 6.1、安装nvm
- 6.2、安装Node.js
- 6.3、开发工具
- 6.4、Vite创建项目
- 6.5、Vue3.js基本语法

## 第七章 客户端技术栈

- 7.1、前端路由 - vue-router
- 7.2、状态管理 - pinia
- 7.3、登录状态 - js-cookie
- 7.4、网络请求库 - axios
- 7.5、css样式库 - tailwindcss
- 7.6、样式组件库 - element-plus
- 7.7、css生成工具 - less

## 第八章 客户端-后台管理

- 8.1、登录/退出
- 8.2、文章分类列表
- 8.3、文章分类编辑
- 8.4、文章列表页
- 8.5、文章编辑页

## 第九章 客户端-前台展示

- 9.1、首页
- 9.2、博客列表页
- 9.3、博客详情页

## 第十章 客户端部署

- 10.1、前端代码部署 - nginx

## 第十一章 项目总结

- 11.1、技术总结
- 11.2、未来展望