# 数据类型-Set集合

多个数据选项可以同时保存，本质按照对应的二进制位来控制
- 1表示选中
- 0表示没有选中

语法
```
set('值1', '值2'...)
```

```
1个字节，set只能有8个选项
2个字节，set只能有16个选项
3个字节，set只能有24个选项
8个字节，set只能有64个选项
```

set和enum一样，最终存储到数据字段中的依然是数字而不是真实的字符串
```sql
create table my_set(
    hobby set('篮球', '足球', '羽毛球', '乒乓球')
);

mysql> desc my_set;
+-------+------------------------------------------------+------+-----+---------+-------+
| Field | Type                                           | Null | Key | Default | Extra |
+-------+------------------------------------------------+------+-----+---------+-------+
| hobby | set('篮球','足球','羽毛球','乒乓球')           | YES  |     | NULL    |       |
+-------+------------------------------------------------+------+-----+---------+-------+

-- 多个选项逗号隔开
insert into my_set (hobby) values ('篮球,足球,乒乓球');

mysql> select * from my_set;
+-------------------------+
| hobby                   |
+-------------------------+
| 篮球,足球,乒乓球        |
+-------------------------+

-- 数据选项与插入的顺序无关，最终会变成选项对应的顺序
insert into my_set (hobby) values ('足球,篮球');

mysql> select * from my_set;
+-------------------------+
| hobby                   |
+-------------------------+
| 篮球,足球,乒乓球        |
| 篮球,足球               |
+-------------------------+
```

## 数据存储的方式

系统将对应的数据选项按照顺序进行编排，从第一个开始进行占位，每一个都对应一个二进制位

数据存储的时候，如果被选中，那么对应的为的值就变为1，否则为0

系统在存储的时候，会自动将的得到的二进制反转，然后转换成十进制存储

```
set('篮球','足球','羽毛球','乒乓球')
      1     1       1       1

('篮球,足球,乒乓球')
      1 1 0 1
反转： 1 0 1 1  =》 1 + 2 + 8 = 11

('足球,篮球')
      1  1  0  0
反转： 0  0   1   1  =》 1 + 2 = 3
```

```sql
-- 以数值方式查看数字
mysql> select hobby + 0 from my_set;
+-----------+
| hobby + 0 |
+-----------+
|        11 |
|         3 |
+-----------+
```

可以插入数值代替实际插入

```sql
mysql> insert into my_set (hobby) values (15);

mysql> select hobby from my_set;
+-----------------------------------+
| hobby                             |
+-----------------------------------+
| 篮球,足球,乒乓球                  |
| 篮球,足球                         |
| 篮球,足球,羽毛球,乒乓球           |
+-----------------------------------+
```

集合的意义

- 规范数据
- 节省存储空间

- enum单选
- set复选


