# PHP 运算符 operator

## 赋值运算符

`=` 将右边的结果（变量，数据，常量）保存到内存的某个位置，然后将位置的内存地址赋值给左侧的变量

## 算术运算符

- 加 `+`
- 减 `-`
- 乘 `*`
- 除 `/`
- 取余 `%`

注意：除法和取余的第二个参数不能为 0

```php
// 连贯赋值运算
$a = $b = 10;
```

## 比较运算符

比较两个数据，返回 bool 值

```
> 大于
>= 大于等于
< 小于
<= 小于等于
== 相等，值相等
!= 不相等
=== 全等，数据类型和数据值都相等
!== 全不相等
```

```php
<?php

$a = 123;
$b = '123';

var_dump($a == $b);
// bool(true)

var_dump($a === $b);
// bool(false)
```

## 逻辑运算符

返回 bool 值

```
&& 逻辑与 两边都为true
|| 逻辑或 一边为true
!  逻辑非 取反
```

```php
<?php

$a = 'tom';
$b = 'jacks';

// 逻辑与
var_dump($a == 'tom' && $b == 'jack');
// bool(false)

// 逻辑或
var_dump($a == 'tom' || $b == 'jack');
// bool(true)

// 逻辑非
var_dump($b == 'jack');
// bool(false)
var_dump(!($b == 'jack'));
// bool(true)
```

逻辑与和逻辑非，又称为短路运算，如果第一个表达式满足条件，就不会判断第二个条件

一般把频率出现高（能够直接判断出结果）的放在第一位

## 连接运算符

PHP 中将多个字符串拼接在一起

- `.` 将两个字符串连接到一起
- `.=` 复合运算，两个字符连接起来，并赋值给左边变量

```php
<?php

$a = 'Hello';
$b = 'World';

var_dump($a . $b);
// string(10) "HelloWorld"


// 相当于 $a = $a . $b;
$a .= $b;
var_dump($a);
// string(10) "HelloWorld"
```

## 错误抑制符

`@` 不显示报错内容

```php
<?php

echo @(1/0);
// INF
```

通常在生产环境使用

## 三目运算符

有三个表达式参与运算，简单的分支结构

语法格式

```
表达式1 ? 表达式2 : 表达式3
```

如果表达式 1 为 ture, 执行表达式 2, 否则执行表达式 3

```php
<?php

echo 1 > 10 ? '1大于10': '1小于10';
// 1小于10
```

复合三目运算符

```
表达式1 ? (表达式2 ? 表达式3 : 表达式4) : (表达式5 ? 表达式6 : 表达式7)
```

## 自操作运算符

- `++` 原来的值 +1
- `--` 原来的值 -1

```php
$a = 1;
$a++; // $a = $a + 1;
```

前置操作和后置操作

```php
<?php

$a = 1;

// 独立操作
$a++;
var_dump($a);
// int(2)

++$a;
var_dump($a);
// int(3)

// 非独立操作
$b = $a++;
$c = ++$a;
var_dump($b); // int(3)
var_dump($c); // int(5)
var_dump($a); // int(5)
```

衍生符号，类似自操作

```
+= $a += $b; <==>  $a = $a + $b;
-=
*=
/=
%=
```

需要注意除法或取余，右边的操作数为 0 的情况

## 计算机码

计算机码：计算机实际存储数据的时候，采用的编码规则（二进制规则）

数值本身最左边第一位是符号位，正数 0，负数 1

原码、反码、补码

- 原码 数据本身从十进制转换成二进制得到的结果
  - 正数：左边符号位为 0（正数的原码，反码和补码就是原码本身）
  - 负数：左边符号位为 1
- 反码 针对负数，符号位不变，其他位取反
- 补码 针对负数，反码+1

系统中存在两个 0

```
+0 0000 0000
-0 1000 0000 原码
取反 1111 1111
补码 0000 0000
```

```
+5 0000 0101（原码、反码、补码都是 ）

-5 原码 1000 0101
   反码 1111 1010 符号位不变，其他位取反
   补码 1111 1011 反码+1
```

## 位运算符

位运算：取出计算机中最小的单位（位 bit）进行运算

```
&   按位与    两位都为1，结果为1，否则为0
|   按位或    有一个为1，结果为1
~   按位非    如果为1，结果为0；如果为0，结果为1
^   按位异或  两位相同则为0，不同为1
<<  按位左移  所有位向左移动一位，右边补0，相当于乘以2
>>  按位右移  所有为向右移动一位，左边补符号位对应内容（正数补0，负数补1），相当于除以2
```

注意：

- 系统进行任何位运算的时候使用的都是补码
- 运算结束之后都必须转换成原码才是最终显示的数据

按位与

```php
<?php

$a = 5;
$b = -5;

var_dump($a & $b);
// int(1)

// 计算过程：
// 5 0000 0101 (正数 原码==反码==补码)
// -5 1000 0101（原码）
// -> 1111 1010（反码）
// -> 1111 1011（补码）

// 5  0000 0101
// -5 1111 1011（补码）
// &  0000 0001 正数
// 判断符号位：0表示正数（原码），1表示负数（补码）

```

按位非运算

```php
<?php

$b = -5;

var_dump(~$b);
// int(4)

// 计算过程：
// -5 1000 0101（原码）
// -> 1111 1010（反码）
// -> 1111 1011（补码）

// -5 1111 1011（补码）
// ~  0000 0100 正数
//  4

```

按位右移

```php
<?php

$b = -5;

var_dump($b>>2);
// int(-2)

// 计算过程：
// -5 1000 0101（原码）
// -> 1111 1010（反码）
// -> 1111 1011（补码）

// -5   1111 1011（补码）
// >>2  --11 1110
//      1111 1110 运算结果，左边补符号位（符号位为0，是负数补码）
//  -1  1111 1101   反码
//      1000 0010   原码
//      -2

```

运算符的优先级（由高到低）

| 结合方向 | 运算符                                                       | 附加信息                                                     |
| -------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| 不适用   | clone new                                                    | clone 和 new                                                 |
| 右       | \*\*                                                         | 算术运算符                                                   |
| 不适用   | + - ++ -- ~ (int) (float) (string) (array) (object) (bool) @ | 算术 (一元 + 和 -)， 递增/递减， 按位， 类型转换 和 错误控制 |
| 左       | instanceof                                                   | 类型                                                         |
| 不适用   | !                                                            | 逻辑运算符                                                   |
| 左       | \* / %                                                       | 算术运算符                                                   |
| 左       | + - .                                                        | 算数 (二元 + 和 -)， array 和 string （. PHP 8.0.0 前可用）  |
| 左       | << >>                                                        | 位运算符                                                     |
| 左       | .                                                            | string （PHP 8.0.0 起可用）                                  |
| 无       | < <= > >=                                                    | 比较运算符                                                   |
| 无       | == != === !== <> <=>                                         | 比较运算符                                                   |
| 左       | &                                                            | 位运算符 和 引用                                             |
| 左       | ^                                                            | 位运算符                                                     |
| 左       | \|                                                           | 位运算符                                                     |
| 左       | &&                                                           | 逻辑运算符                                                   |
| 左       | \|\|                                                         | 逻辑运算符                                                   |
| 右       | ??                                                           | null 合并运算符                                              |
| 无关联   | ? :                                                          | 三元运算符 (PHP 8.0.0 之前左联)                              |
| 右       | = += -= \*= \*\*= /= .= %= &= \|= ^= <<= >>= ??=             | 赋值运算符                                                   |
| 不适用   | yield from                                                   | yield from                                                   |
| 不适用   | yield                                                        | yield                                                        |
| 不适用   | print                                                        | print                                                        |
| 左       | and                                                          | 逻辑运算符                                                   |
| 左       | xor                                                          | 逻辑运算符                                                   |
| 左       | or                                                           | 逻辑运算符                                                   |

文档：[https://www.php.net/manual/zh/language.operators.precedence.php](https://www.php.net/manual/zh/language.operators.precedence.php)
