# Vue.js

```html
<!-- Production -->
<script src="//cdn.jsdelivr.net/npm/vue@2/dist/vue.min.js"></script>
```

[vue.md](blog/vue.md)

[BootstrapVue](https://bootstrap-vue.org/): 一个用于 Vue.js 构建引导接口的开源库。

[Vuex](https://vuex.vuejs.org/) :Vue.js 应用程序的状态管理库。

[Vue Devtools](https://devtools.vuejs.org/) 一个调试 Vue.js 项目的简单工具。

[Vue CLI](https://cli.vuejs.org/) Vue.js 开发人员更简单的标准工具。

[Vue Router](https://router.vuejs.org/) 直观而强大的语法定义静态和动态路由。


[Nuxt](https://nuxtjs.org/) 一个开源框架，使Web开发变得简单而强大。

[Vue Element Admin](https://github.com/PanJiaChen/vue-element-admin) 帮助构建具有管理网站所需的许多功能的简单管理界面。

[Vue Apollo](https://vue-apollo.netlify.app/) 它可以帮助我们的 Vue.js 项目设置 GraphQL 变得更容易。

### UI库

[vue3.js](https://staging-cn.vuejs.org/) | [vue2.js](https://cn.vuejs.org/v2/guide/): 渐进式 JavaScript 框架

- [element-ui](https://element.eleme.cn/#/zh-CN/component/installation): 一套为开发者、设计师和产品经理准备的基于 Vue 2.0 的桌面端组件库
- [vColorPicker](http://vue-color-picker.rxshc.com/): 基于 Vue 的颜色选择器插件
- [vuedraggable](https://www.npmjs.com/package/vuedraggable)
- [Vuetify](https://vuetifyjs.com/zh-Hans/) 是一个纯手工精心打造的 Material 样式的 Vue UI 组件库。
- [arco-design](https://arco.design/)字节跳动出品的企业级UI库（Vue.js3）
- [ant-design-vue](https://2x.antdv.com/docs/vue/getting-started-cn) 企业级应用的最佳 UI 实践
- [heyui](https://www.heyui.top/) | [github](https://github.com/heyui/heyui): 一个基于Vue.js的高质量UI组件库


[Vuetifyjs](https://vuetifyjs.com/zh-Hans/) 帮助构建 Vue.js 的 Material Design 接口的开源库。

[Element UI](https://element.eleme.io/#/en-US) 用于Vue项目界面开发的UI库。

[arco.design](https://arco.design/vue/docs/start) 字节跳动出品的企业级设计系统

[ant-design-vue](https://antdv.com/components/overview-cn): 为 Web 应用提供了丰富的基础 UI 组件。

 - github: [ant-design-vue](https://github.com/vueComponent/ant-design-vue)

[Quasar](https://quasar.dev/) Quasar 是一个开源的 Vue.js 框架，可帮助构建 SPA（单页应用）、SSR（服务器端渲染应用）、PWA（渐进式 Web 应用）。

[Language Vue](https://atom.io/packages/language-vue) 支持 Atom 的 Vue.js 开发的实用程序。

[VuePress](https://v2.vuepress.vuejs.org/) VuePress 是一个以降价为中心的静态站点生成器。

[Vue.js Guide](https://vuejs.org/guide/introduction.html) Vue.js 开发人员最完整、最详细的指南。

[Vue Select](https://vue-select.org/) 帮助我们构建具有对 Vue.js 开发人员有用的功能的组件。

[Vueuse](https://vueuse.org/) Vue 2 和 Vue 3 组件的必要实用程序集合。

[VeeValidate](https://vee-validate.logaretm.com/v4/) Vue.js 中的表单验证工具。

[Vant](https://vant-contrib.gitee.io/vant/#/en-US) 移动 UI 的界面构建器库。

[Vue Native](https://vue-native.io/) 帮助构建跨平台原生移动应用的 JavaScript 框架。

[Vue-meta](https://vue-meta.nuxtjs.org/) Vue.js 项目的 Cmeta 标签管理器。

[Vue I18n](https://kazupon.github.io/vue-i18n/) 插件有助于为项目添加国际功能。

[Vue Infinite Loading](https://peachscript.github.io/vue-infinite-loading/) 为网站创建无限滚动功能。

[Gridsome](https://gridsome.org/) 该工具可以快速轻松地构建静态网站和应用程序。

[Vite](https://vitejs.dev/) Vite 是一个构建工具，旨在为现代 Web 项目提供更快、更精简的开发体验。

[Vue-multiselect](https://vue-multiselect.js.org/) 帮助为网站构建多选功能的开源库。

[Vetur](https://marketplace.visualstudio.com/items?itemName=octref.vetur) 用于在 VSCode 中更好地进行 Vue.js 开发和调试的扩展。

[Vue.js Examples](https://vuejsexamples.com/) Vue.js 接口开发中的示例集合。


## 文章

[分享 27 个面向开发人员的最佳 Vue.js 开发工具](https://mp.weixin.qq.com/s/L7aeQ-VrPvjLoqVas8XZ_g)
