# PHP 流程控制

代码执行的方向

## 控制分类

- 顺序结构 代码从上往下，顺序执行
- 分支结构 根据条件执行某一段代码
- 循环结构 指定代码块重复执行

## 顺序结构

最基本的结构，所有代码默认都是从上往下依次执行

## 分支结构

1、if 分支

基本语法

```php
// 1、最简if
if(条件表达式){
    // 满足条件所要执行的代码
}

// 2、基础if
if(条件){
    // 满足
}
else{
    // 不满足
}

// 3、复杂if
if(条件1){
    // 满足条件1
}
else if(条件2){
    // 满足条件2
}
else{
    // 不满足
}
```

注意: 嵌套层数不宜过多

示例

```php
<?php

$a = 1;

if ($a == 1) {
    echo '星期一';
} else if ($a == 2) {
    echo '星期二';
} else {
    echo '未知';
}

// 星期一
```

2、switch 分支

使用场景：同一个条件有多个值

基本语法

```php
switch(条件表达式){
    case 值1: // 判断表达式的结果与值相等
        要执行的代码段1;
        break;
    case 值2:
        要执行的代码段2;
        break;
    ...
    default:
        默认自行的代码;
}
```

switch 匹配成功后，会执行之后的代码，需要使用 break 跳出

```php
<?php

$a = 1;

switch ($a) {
    case 1:
        echo '星期一';
        break;
    case 2:
        echo '星期二';
        break;
    default:
        echo '未知';
}

// 星期一
```

if 和 switch 的选择

- if 能做所有的的分支结构
- switch 处理的条件多，用于固定的条件

## 循环结构

- for 循环
- while 循环
- do-while 循环
- foreach 循环，专门针对数组

1、for 循环

基本语法

```
for(初始化条件; 边界表达式; 条件变化){
   // 循环体
}
```

示例
```php
<?php

// 循环输出1-10
for ($i = 1; $i <= 10; $i++) {
    echo $i . ' ';
}

// 1 2 3 4 5 6 7 8 9 10

// 初始化语句中，定义多个变量
for ($i = 1, $end = 10; $i <= $end; $i++) {
    echo $i . ' ';
}
```

For循环特殊使用：死循环，避免出现

```php
for(;;){
    // 无限循环 
}
```

2、while循环

基本语法

```php
条件初始化;

while（条件表达式）{
    // 循环体
    // 循环条件的变化
}
```

示例
```php
<?php

$i = 1;

while( $i <= 10 ){
    echo $i . ' ';
    $i++;
}

// 1 2 3 4 5 6 7 8 9 10 
```

For和while的选择

- For循环：基于已知条件，数值有规律变化
- while循环：灵活条件判定



3、do-while

基本语法

```
do{
    // 循环体
} while(判断条件);

```

示例

```php
<?php

$i = 1;

do{
    echo $i . ' ';
    $i++;
}
while( $i <= 10 );

// 1 2 3 4 5 6 7 8 9 10 
```

## 循环控制 

在循环体内部对循环本身进行控制

- 中断控制 continue：重新开始循环，循环体重还有其他内容，也执行
- 终止控制 break：循环直接结束

```php
<?php

for ($i=0; $i < 10; $i++) { 
    if($i % 2 == 0){
        continue;
    }

    if($i == 8){
        break;
    }

    echo $i . ' ';
}

// 1 3 5 7 9 
```

## 流程控制替代语法

分支和循环结构的替代语法

HTML和PHP进行混搭

```php
<table>
    <!-- 输出 99乘法表 -->
    <?php for ($i = 1; $i < 10; $i++) { ?>
        <tr>
            <?php for ($j = 1; $j <= $i; $j++) { ?>
                <td> <?php echo $i . ' * ' . $j . ' = ' . $i * $j; ?></td>
            <?php } ?>
        </tr>
    <?php } ?>
</table>
```

```
1 * 1 = 1
2 * 1 = 2   2 * 2 = 4
3 * 1 = 3   3 * 2 = 6   3 * 3 = 9
4 * 1 = 4   4 * 2 = 8   4 * 3 = 12  4 * 4 = 16
5 * 1 = 5   5 * 2 = 10  5 * 3 = 15  5 * 4 = 20  5 * 5 = 25
6 * 1 = 6   6 * 2 = 12  6 * 3 = 18  6 * 4 = 24  6 * 5 = 30  6 * 6 = 36
7 * 1 = 7   7 * 2 = 14  7 * 3 = 21  7 * 4 = 28  7 * 5 = 35  7 * 6 = 42  7 * 7 = 49
8 * 1 = 8   8 * 2 = 16  8 * 3 = 24  8 * 4 = 32  8 * 5 = 40  8 * 6 = 48  8 * 7 = 56  8 * 8 = 64
9 * 1 = 9   9 * 2 = 18  9 * 3 = 27  9 * 4 = 36  9 * 5 = 45  9 * 6 = 54  9 * 7 = 63  9 * 8 = 72  9 * 9 = 81
```

另一种书写for的方式

```php
<table>
    <!-- 输出 99乘法表 -->
    <?php for ($i = 1; $i < 10; $i++) : ?>
        <tr>
            <?php for ($j = 1; $j <= $i; $j++) : ?>
                <td> <?php echo $i . ' * ' . $j . ' = ' . $i * $j; ?></td>
            <?php endfor ?>
        </tr>
    <?php endfor ?>
</table>
```

PHP在HTML中应该只做数据输出
```
if() {} => if(): endif;
```