# PHP 变量和常量

## PHP 基本语法

PHP 是一种运行在服务器端的脚本语言，可以嵌入到 HTML 中

1、PHP 代码标记

- ASP 标记(asp_tags，已弃用) `<% php代码 %>`
- 段标记(short_open_tags, 已弃用) `<? php代码 ?>`
- 脚本标记 `<script language="php" >php代码</script>`
- 标准标记（常用） `<?php php代码 ?>`

2、PHP 注释

解析过程中会被忽略

```php
// 行注释
# 注释一行

/* 块注释
 * 多行注释
*/
```

3、PHP 语句分隔符（分号）

```php
<?php

echo 'hello world';
echo 'hello world';

```

特殊说明：

- 标记结束符`?>` 可以省略，如果是单独的 PHP 文件，一般会省略
- 最后一行结尾的分号可以省略，不推荐

## PHP 变量

PHP 是一种动态网站开发的脚本语言，动态语言的特点是交互性，会有数据传递

1、概念

- 变量可以存储数据
- 变量有名字
- 变量可以通过名字访问数据
- 变量可以改变

2、使用

变量必须使用`$`开头

- 定义：在系统内存中增加对应的变量名
- 赋值：将数据赋值给变量，可以再定义的同时完成
- 访问：可以通过变量名访问数据
- 删除：将变量从内存中删除

```php
<?php

// 定义变量
$var1;

// 定义同时赋值
$var2 = 1;

// 访问变量
echo $var2 . '<br>';


// 修改变量
$var2 = 2;
echo $var2 . '<br>';;

// 删除变量
unset($var2);
echo $var2;

```

3、变量命名规则

- PHP 变量名必须以`$`开头
- 可以使用数字，字母，下划线，不能以字母开头
- 支持中文，不建议

```php
<?php

// 正确形式
$var1;$var_2;$_var_3;

// 错误格式
// $1var;

// 支持中文
$中文 = 'china';

```

4、预定义变量（系统定义的变量）

```php
$_GET     GET提交的数据
$_POST    POST提交的数据
$_REQUEST GET和POST的提交的数据
$GLOBALS  全局变量
$_SERVER  服务器信息
$_SESSION session
$_COOKIE  cookie
$_ENV     环境变量
$_FILES   用户上传的文件信息
```

5、可变变量

如果一个变量保存的值，刚好是另一个变量的名字，那么可以直接通过访问一个变量得到另一个变量的值

在变量前多加一个`$`符号

```php
<?php

$a = 'b';
$b = 'bb';

echo $$a;
// 输出：bb
```

6、变量传值

将一个变量赋值给另一个变量

变量传递方式

- 值传递：变量的值复制一份，给另个变量保存，（两个变量没有关系）
- 引用传递：将变量保存的值所在内存地址，赋值给另一个变量，两个变量指向同一块内存地址（两个变量是同一个值）

内存分区

- 栈区：程序可以操作的内存部分，不存数据，运行程序代码
- 代码段：存储程序，不执行
- 数据段：存储普通数据（全局区和静态区）
- 堆区：存储复杂数据，效率低

值传递

```php
$a = 1;
$b = $a;
```

```
栈区  数据段
$a -> 1
$b -> 1（副本）
```

引用传递

```php
$a = 1;
$b = &$a;
```

```
栈区  数据段
$a -> 1
$b -> 1（同一个值）
```

## PHP 常量

常量与变量一样，都是用来保存数据

1、常量的基本概念

- 常量 const / constant 程序运行中，不可改变的量

- 常量一旦定义，通常数据不可改变（用户级）

2、常量定义形式

```php
<?php

// 方式一
define(常量名, 常量值);

// eg
define('PI', 3.14);

// 方式二: php > 5.3
const 常量名 = 常量值;

// eg
const PIPI = 3.14;
```

3、常量命名规则

- 常量不需要使用`$`符号，`$`开头的系统认为是变量
- 常量有数字、字母、下划线组成，不能以数字开头
- 常量名通常以大写字母为主，与变量区别

define 可以定义特殊常量

```php
<?php

define('-_-', 3.14);
```

区别

- 访问权限有区别
- define 定义常量通常区分大小写，可以通过第三个参数设置

```php
define(string $constant_name, mixed $value, bool $case_insensitive = false): bool

// PHP 7.3.0 起废弃了定义不区分大小写的常量。
// ref: https://www.php.net/define
```

4、使用常量

```php
<?php

// 常量
define('PI', 3.14);

echo PI;


// 特殊符号常量
define('-_-', 3.14);

echo constant('-_-');
```

5、常量和变量的使用

- 数据可能会变化的，使用变量
- 数据不一定不会变化，使用常量或变量
- 数据不允许修改，一定使用常量

## 系统常量

```php
<?php

// PHP版本号
echo PHP_VERSION;
// 7.1.23

// 整型占用字节数
echo  PHP_INT_SIZE;
// 8

// 整型能表示的最大值
echo  PHP_INT_MAX;
// 9223372036854775807
```

## 特殊常量（魔术常量）

```
__DIR__        当前被执行脚本文件夹绝对路径
__FILE__       当前被执行脚本文件绝对路径
__LINE__       当前行号
__NAMESPACE__  当前命名空间
__CLASS__      当前所属类
__METHOD__     当前所属方法
```
